//
//  SurveySmartphoneUsageStudyInformationViewController.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 27.06.23.
//

import Foundation
import UIKit

class SurveySmartphoneUsageStudyInformationViewController : UIViewController {
    
    @IBOutlet var homeButton: UIButton!
    
    @IBOutlet var acceptStudyTermsButton: UIButton!
    
    @IBOutlet var studyHeaderLabel: UILabel!
    
    @IBOutlet var studyDetailsLabel: UILabel!
    
    var textArray_studyDetailsLabel = [String]()
    var fontArray_studyDetailsLabel = [UIFont]()
    var colorArray_studyDetailsLabel = [UIColor]()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : Colors.carmine,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        
        homeButton.backgroundColor = UIColor.clear
        homeButton.setImage(UIImage(systemName: "homeButton"), for: .normal)
        homeButton.tintColor = UIColor.init(red: 169.0/255.0, green: 1/255.0, blue: 25/255.0, alpha: 1.0)
        
        homeButton.frame.size = CGSize(width: 15, height: 15)
        homeButton.addTarget(self, action: #selector(pressedHomeButton(_ :)), for: .touchUpInside)
        
        
        studyHeaderLabel.text = "Studie zum Thema „Smartphone Nutzung“ der Ruhr-Universität Bochum"
        
        textArray_studyDetailsLabel.append("Vielen Dank für Ihr Interesse an unserer Studie!\n\nIn dieser Studie werden wir Ihnen eine Reihe von Fragen zu Ihrer Smartphone Nutzung stellen. Ziel dieser Umfrage ist es, ein umfassendes Bild über die Nutzung und Wahrnehmung  von Smartphones und Apps in der deutschen Bevölkerung zu erhalten. Mit Ihrer Teilnahme können Sie einen wertvollen Beitrag dazu leisten.")
        textArray_studyDetailsLabel.append("\n\nZweck:")
        textArray_studyDetailsLabel.append("Diese wissenschaftliche Studie untersucht Ihre Nutzung und Wahrnehmung von Smartphone Apps.")
        textArray_studyDetailsLabel.append("\n\nVoraussetzungen:")
        textArray_studyDetailsLabel.append("Um an dieser Studie teilnehmen zu können, müssen Sie mindestens 18 Jahre alt sein.")
        textArray_studyDetailsLabel.append("\n\nDauer:")
        textArray_studyDetailsLabel.append("Die Teilnahme an der Studie dauert voraussichtlich 5 Minuten. Die Teilnahme ist für Sie mit keinen erwarteten Risiken verbunden. Bitte beantworten Sie den Fragebogen möglichst ehrlich. Falls Sie nicht mehr an der Studie teilnehmen möchten, können Sie diese jederzeit abbrechen, solange Sie Ihre Antworten noch nicht abgeschickt haben bzw. diese noch nicht ausgewertet wurden.")
        textArray_studyDetailsLabel.append("\n\nKontakt:")
        textArray_studyDetailsLabel.append("Die Studie wird von Wissenschaftlerinnen und Wissenschaftlern der Fakultät für Informatik der Ruhr-Universität Bochum durchgeführt. Bei Fragen zu oder Problemen mit dieser Forschung können Sie sich jederzeit an mobsec-studies@rub.de wenden. Weitere Informationen zu den Kontaktdaten finden Sie im Impressum.")
        textArray_studyDetailsLabel.append("\n\nDatenschutz:")
        textArray_studyDetailsLabel.append("Ihre Antworten werden im Rahmen dieser Studie in pseudonymisierter Form gespeichert. Wir erfragen keine Informationen, die Sie persönlich identifizieren könnten. Die Daten werden im Auftrag der Ruhr-Universität Bochum erhoben.\nDurch Starten des Fragebogens stimmen Sie der Datenerhebung für den Zweck der Durchführung dieser Studie zu. Die Verarbeitung Ihrer personenbezogenen Daten erfolgt auf Grundlage von Art. 6 (1) a DSGVO und § 17 DSG NRW. Sie haben das Recht, Ihre Einwilligung in die Datenverarbeitung jederzeit zu widerrufen, sowie Auskunft, Korrektur, Beschränkung der Verarbeitung sowie Löschung der über Sie gespeicherten Daten zu verlangen. Um diese Rechte wahrzunehmen, kontaktieren Sie bitte die oben genannte E-Mail-Adresse. Die zuständige Aufsichtsbehörde ist die Landesdatenschutzbeauftragte des Landes Nordrhein-Westfalen.")

        fontArray_studyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_studyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        colorArray_studyDetailsLabel.append(Colors.greyColor)
        
        
        self.studyDetailsLabel.attributedText = getAttributedString(arrayText: textArray_studyDetailsLabel, arrayColors: colorArray_studyDetailsLabel, arrayFonts: fontArray_studyDetailsLabel)
        
        Utilities.styleFilledButtonContinueBlue(acceptStudyTermsButton)
        
    }
    
    @objc func pressedHomeButton(_ sender: UIButton) {
        print("Home Button Pressed")
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController

        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()
    }
    
    
    
    @IBAction func acceptStudyTermsButton(_ sender: Any) {
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "SurveySmartphoneUsage01NC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .coverVertical
        
        present(nc, animated: true)
}

    func getAttributedString(arrayText:[String]?, arrayColors:[UIColor]?, arrayFonts:[UIFont]?) -> NSMutableAttributedString {
        
        
        
        let finalAttributedString = NSMutableAttributedString()
        
        for i in 0 ..< (arrayText?.count)! {
            
            var attributes = [NSAttributedString.Key.foregroundColor: arrayColors?[i], NSAttributedString.Key.font: arrayFonts?[i]]
            let attributedStr = (NSAttributedString.init(string: arrayText?[i] ?? "", attributes: attributes as [NSAttributedString.Key : Any]))
            
            if i != 0 {
                
                finalAttributedString.append(NSAttributedString.init(string: " "))
            }
            
            finalAttributedString.append(attributedStr)
        }
        
        return finalAttributedString
    }


}
